package com.meta.android.mpg.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.meta.android.mpg.account.callback.AccountChangedListener;
import com.meta.android.mpg.account.callback.LoginResultCallback;
import com.meta.android.mpg.account.model.UserInfo;
import com.meta.android.mpg.common.MetaApi;
import com.meta.android.mpg.payment.callback.PayResultCallback;
import com.meta.android.mpg.payment.constants.MetaPayResult;
import com.meta.android.mpg.payment.model.PayInfo;

public class ActivityForTestLoginPay extends AppCompatActivity {

    private String metaUid;
    private String metaSid;
    private String metaUserName;
    private String metaUserIcon;
    private TextView contentTv;
    private TextView orderTv;
    private Button       loginBtn;
    private LinearLayout payLayout;
    private Button       payBtn;
     private Button realNameBtn;

    private AccountChangedListener mAccountChangedListener = new AccountChangedListener() {
        @Override
        public void onAccountChanged(UserInfo userInfo) {
            changeUser(userInfo);
            Log.i("ActivityForTestLoginPay", "账号变更通知=" + userInfo);
        }

        @Override
        public void onAccountLogout() {
            Log.i("ActivityForTestLoginPay", "点击悬浮球的账号切换，账号退出了=");
            Toast.makeText(ActivityForTestLoginPay.this, "账号退出了", Toast.LENGTH_SHORT).show();
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_for_test_login_pay);

        contentTv = findViewById(R.id.contentTv);
        orderTv = findViewById(R.id.orderTv);
        loginBtn = findViewById(R.id.loginBtn);
        payLayout = findViewById(R.id.ll_pay);
        EditText moneyEt = findViewById(R.id.et_money);
        payBtn = findViewById(R.id.payBtn);
        realNameBtn = findViewById(R.id.realNameBtn);

        MetaApi.registerAccountChangedListener(mAccountChangedListener);

        loginBtn.setOnClickListener(v -> MetaApi.login(this, new LoginResultCallback() {
            @Override
            public void loginSuccess(UserInfo userInfo) {
                Toast.makeText(ActivityForTestLoginPay.this, "登录成功", Toast.LENGTH_SHORT).show();
                changeUser(userInfo);
            }

            @Override
            public void loginFail(int code, String msg)  {
                if (code == 14) {
                    //黑名单限制登录
                }
                Toast.makeText(ActivityForTestLoginPay.this, "登录失败: " + msg, Toast.LENGTH_SHORT).show();
            }
        }));

        payBtn.setOnClickListener(v -> {
            orderTv.setText("支付订单");

        String cpOrderId = String.valueOf(System.currentTimeMillis());
        int price = Integer.parseInt(moneyEt.getText().toString());
        //透传字段
        String extra = ""; //传入游戏自定义扩展字段，支付成功后原样返回给游戏服务器
        PayInfo payInfo = new PayInfo.Builder()
                .setCpOrderId(cpOrderId) //
                .setProductCode("pCode0101") //商品编码
                .setProductName("10钻石") //商品名称
                .setPrice(price * 100) //商品价格，单位(分)
                .setProductCount(1) //商品数量，默认是1
                .setCpExtra(extra)
                .build();

        MetaApi.pay(ActivityForTestLoginPay.this, payInfo, new PayResultCallback() {

            @Override
            public void onPayResult(int code, String msg) {
                if (code == MetaPayResult.CODE_PAY_SUCCESS) {
                    Toast.makeText(ActivityForTestLoginPay.this, "支付成功", Toast.LENGTH_SHORT).show();
                    orderTv.setText("支付结果：支付成功");
                } else {
                    Toast.makeText(ActivityForTestLoginPay.this, "支付失败", Toast.LENGTH_SHORT).show();
                    orderTv.setText("支付结果：支付失败,code=" + code);
                }
            }
        });
        });

        realNameBtn.setOnClickListener(v -> {
            Intent intent = new Intent(ActivityForTestLoginPay.this, RealNameActivity.class);
            startActivity(intent);
        });
    }

    private void changeUser(UserInfo userInfo) {
        metaUid = userInfo.uid;
        metaSid = userInfo.sid;
        metaUserName = userInfo.userName;
        metaUserIcon = userInfo.userIcon;

        contentTv.setText("hello, " + userInfo.userName);
        loginBtn.setVisibility(View.GONE);
        payLayout.setVisibility(View.VISIBLE);
        realNameBtn.setVisibility(View.VISIBLE);
    }

    @Override
    protected void onDestroy() {
        MetaApi.unregisterAccountChangedListener(mAccountChangedListener);
        super.onDestroy();
    }
}
