package com.meta.android.mpg.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import com.meta.android.mpg.account.callback.LoginResultCallback;
import com.meta.android.mpg.account.model.UserInfo;
import com.meta.android.mpg.common.MetaApi;
import com.meta.android.mpg.initialize.InitCallback;

public class MainActivity extends AppCompatActivity {

    private TextView tvResult;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        tvResult = findViewById(R.id.tv_result);
        initSdk();
        findViewById(R.id.testLoginPay).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, ActivityForTestLoginPay.class);
                startActivity(intent);
            }
        });
    }

    private void initSdk() {
        String appKey = "1044439129"; //使用平台分配的appKey
        String cpId = "1044"; //使用平台分配的cpId
        MetaApi.initMetaSdk(this, appKey, cpId, new InitCallback() {
            @Override
            public void onInitializeSuccess() {
                Log.i("SdkHelper", "init success");
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        doLogin();
                    }
                });

            }

            @Override
            public void onInitializeFail(int i, String s) {
                Log.i("SdkHelper", "init fail=" + s);
                tvResult.setText("初始化失败，" + s);
            }
        });
    }

    private void doLogin() {
       /* MetaApi.login(this, new LoginResultCallback() {
            @Override
            public void loginSuccess(UserInfo userInfo) {
                Log.i("SdkHelper", "loginSuccess");
                tvResult.setText("登录成功，" + userInfo.userName);
            }

            @Override
            public void loginFail(int i, String s) {
                Log.i("SdkHelper", "loginFail");
                tvResult.setText("登录失败，" + s);
            }
        });*/
        Intent intent = new Intent(MainActivity.this, ActivityForTestLoginPay.class);
        startActivity(intent);
    }
}
