package com.meta.android.mpg.demo;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.meta.android.mpg.account.callback.RealNameAuthenticationCallback;
import com.meta.android.mpg.account.model.RealNameResult;
import com.meta.android.mpg.common.MetaApi;

public class RealNameActivity extends AppCompatActivity {

    private static final String TAG = RealNameActivity.class.getSimpleName();

    private EditText nameEt, idNoEt;
    private TextView logTv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_real_name);
        nameEt = findViewById(R.id.nameEt);
        idNoEt = findViewById(R.id.idNoEt);
        logTv = findViewById(R.id.logTv);
        findViewById(R.id.getRealNameInfoTv).setOnClickListener(v -> {
            MetaApi.registerRealNameCall(false, result -> {
                Log.d(TAG, result.toString());
                logTv.append("realNameResult code:" + result.getReturnCode() + ",msg:" + result.getReturnMsg() + "\n");
                if (result.getAuthInfo() != null) {
                    logTv.append("AuthInfo: Uuid       :" + result.getAuthInfo().getUuid() + "\n");
                    logTv.append("AuthInfo: 年龄       :" + result.getAuthInfo().getAge() + "\n");
                    logTv.append("AuthInfo: 实名状态 0未实名 1已实名:" + result.getAuthInfo().getVerifyStatus() + "\n");
                }
            });
        });

        findViewById(R.id.startRealNameTv).setOnClickListener(v -> {
            if (TextUtils.isEmpty(nameEt.getText().toString()) && TextUtils.isEmpty(idNoEt.getText().toString())) {
                Toast.makeText(RealNameActivity.this, "请输入身份号和姓名", Toast.LENGTH_SHORT).show();
                return;
            }
            MetaApi.realNameAuth(nameEt.getText().toString().trim(), idNoEt.getText().toString().trim(), new RealNameAuthenticationCallback() {

                @Override
                public void realNameAuthenticationResult(RealNameResult result) {
                    Log.d(TAG, result.toString());
                    // result.getReturn_code() == 200 校验通过
                    // result.getReturn_code() == 500 该用户已认证过
                    logTv.append("realNameResult code:" + result.getReturnCode() + ",msg:" + result.getReturnMsg() + "\n");
                }

            });
        });

        findViewById(R.id.showRealNameTv).setOnClickListener(v -> {
            MetaApi.showMetaRealNameActivity(RealNameActivity.this, new RealNameAuthenticationCallback() {
                @Override
                public void realNameAuthenticationResult(RealNameResult result) {
                    Log.d(TAG, result.toString());
                    // result.getReturn_code() == 200 校验通过
                    // result.getReturn_code() == 500 该用户已认证过
                    logTv.append("realNameResult code:" + result.getReturnCode() + ",msg:" + result.getReturnMsg() + "\n");
                }
            });
        });

    }

}