package com.meta.android.mpg.demo;

import android.os.Bundle;

import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import com.meta.android.mpg.cm.BuildConfig;
import com.meta.android.mpg.cm.MetaAdApi;
import com.meta.android.mpg.cm.api.IAdCallback;
import com.meta.android.mpg.cm.api.InitCallback;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // 看日志可以配置这个
        if (BuildConfig.DEBUG) {
            MetaAdApi.get().setLogLevel(5);
        }

        findViewById(R.id.initAdBtn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                initAd();
            }
        });

        findViewById(R.id.adBtn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showRewardAd();
            }
        });
    }

    private void initAd() {
        if (MetaAdApi.get().isInitialized()) {
            makeToast("广告SDK已初始化");
        } else {
            // 申请的 appId
            String appId = "1044439129";
            MetaAdApi.get().init(MainActivity.this.getApplication(), appId, new InitCallback() {
                @Override
                public void onInitSuccess() {
                    makeToast("广告SDK初始化成功");
                }

                @Override
                public void onInitFailed(int errCode, String errMsg) {
                    makeToast(String.format("广告SDK初始化失败：%s, %s", errCode, errMsg));
                }
            });
        }
    }

    private void makeToast(String message) {
        Toast.makeText(MainActivity.this, message, Toast.LENGTH_SHORT).show();
    }

    private void showRewardAd() {
        // 申请的激励广告位
        int pos = 999000000;
        MetaAdApi.get().showVideoAd(pos, new IAdCallback.IVideoIAdCallback() {

            @Override
            public void onAdShow() {
                Log.d("MetaAdApi", "onAdShow");
                makeToast("播放成功");
            }

            @Override
            public void onAdShowFailed(int errCode, String errMsg) {
                Log.d("MetaAdApi", "onAdShowFailed: " + errCode + ", " + errMsg);
                makeToast(String.format("播放失败：%s, %s", errCode, errMsg));
            }

            @Override
            public void onAdClick() {
                Log.d("MetaAdApi", "onAdClick");
                makeToast("点击");
            }

            @Override
            public void onAdClose() {
                Log.d("MetaAdApi", "onAdClose");
                makeToast("关闭播放");
            }

            @Override
            public void onAdClickSkip() {
                Log.d("MetaAdApi", "onAdClickSkip");
                makeToast("跳过");
            }

            @Override
            public void onAdReward() {
                Log.d("MetaAdApi", "onAdReward");
                makeToast("给予奖励");
            }

        });
    }
}